<?php
include "../controllers/pages.php";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pages = new Pages();
  $pages->setParams($_POST, $_FILES);
  $pages->insert();
}

$type_option = array(
  array(
    'value' => 'url',
    'title' => 'Url'
  ),
  array(
    'value' => 'page',
    'title' => 'Page'
  ),
  array(
    'value' => 'screen',
    'title' => 'Screen'
  )
);
?>
 
<!-- Content Header (Page header) -->
<div class="container-fluid">

  <!-- Page Heading -->
  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">افزودن صفحه</h1>
    <ol class="breadcrumb float-sm-right">
      <li class="breadcrumb-item"><a href="index.php">داشبورد</a></li>
      <li class="breadcrumb-item"><a id="goToIndex" href="index.php?page=pages">صفحه</a></li>
      <li class="breadcrumb-item active">افزودن صفحه</li>
    </ol>
  </div>

  <div>
    <div class="card shadow mb-4">
      <!-- Card Header - Dropdown -->
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">افزودن صفحه</h6>
      </div>
      <!-- Card Body -->
      <form method="post" action="" id="form" enctype="multipart/form-data">
        <div class="card-body">

          <div class="card-body">

            <div class="row">
              <div class="form-group col-xl-6 col-md-6 mb-4">
                <label for="title">عنوان</label>
                <input type="text" class="form-control" id="title" name="title" placeholder="عنوان را وارد کنید" required>
              </div>

              <div class="form-group col-xl-6 col-md-6 mb-4">
              </div>

              <div class="form-group col-xl-6 col-md-6 mb-4">
                <label for="url">آدرس</label>
                <input type="url" class="form-control" id="url" name="url" placeholder="آدرس را وارد کنید" required>
              </div>

              <div class="form-group col-xl-6 col-md-6 mb-4">
                <label for="image">تصویر</label>
                <div class="input-group">
                  <div class="custom-file">
                    <input type="file" class="custom-file-input" id="image" name="image" onChange="readURL(this);">
                    <label class="custom-file-label text-center" for="image">انتخاب فایل</label>
                  </div>
                </div>
              </div>

              <div class="form-group col-xl-6 col-md-6 mb-4">
                <label for="status">وضعیت</label>
                <div class="custom-control custom-switch">
                  <input type="checkbox" class="custom-control-input" id="status" name="status" checked data-bootstrap-switch>
                  <label class="custom-control-label" for="status"></label>
                </div>
              </div>

              <div class="form-group col-xl-6 col-md-6 mb-4">
                <img src="../images/pages/default.png?<?= time() ?>" style="width:70px" id="thumb_img" class="img-thumbnail">
              </div>


            </div>
            <button type="submit" class="btn btn-primary btn-icon-split">
              <span class="icon text-white-50">
                <i class="fas fa-save"></i>
              </span>
              <span class="text">ذخیره</span>
            </button>
          </div>
          <!-- /.card-body -->

      </form>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    $('#form').validate({
      rules: {},
      messages: {
        title: {
          required: "لطفا عنوان را وارد کنید",
        },
        url: {
          required: "لطفا آدرس را وارد کنید",
          url: "لطفا آدرس معتبر وارد کنید(http://www.example.com)",
        }
      },
      errorElement: 'div',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
</script>